/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.partbuilder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5455;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.material.IMaterialValue;
import slimeknights.tconstruct.library.recipe.partbuilder.IDisplayPartBuilderRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.IPartBuilderContainer;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.tables.TinkerTables;

public class ItemPartRecipe
implements IDisplayPartBuilderRecipe {
    private final class_2960 id;
    private final MaterialVariant material;
    private final Pattern pattern;
    private final class_1856 patternItem;
    private final int cost;
    private final ItemOutput result;

    public ItemPartRecipe(class_2960 id, MaterialVariantId material, Pattern pattern, class_1856 patternItem, int cost, ItemOutput result) {
        this.id = id;
        this.material = MaterialVariant.of(material);
        this.pattern = pattern;
        this.patternItem = patternItem;
        this.cost = cost;
        this.result = result;
    }

    @Override
    public boolean partialMatch(IPartBuilderContainer inv) {
        if (!this.patternItem.method_8093(inv.getPatternStack())) {
            return false;
        }
        if (!inv.getStack().method_7960()) {
            IMaterialValue materialRecipe = inv.getMaterial();
            return materialRecipe != null && this.material.matchesVariant(materialRecipe.getMaterial());
        }
        return true;
    }

    public boolean matches(IPartBuilderContainer inv, class_1937 worldIn) {
        IMaterialValue materialRecipe = inv.getMaterial();
        return materialRecipe != null && this.material.matchesVariant(materialRecipe.getMaterial()) && inv.getStack().method_7947() >= materialRecipe.getItemsUsed(this.cost);
    }

    public class_1799 method_8110(class_5455 registryAccess) {
        return this.result.get();
    }

    public class_1865<?> method_8119() {
        return (class_1865)TinkerTables.itemPartBuilderSerializer.get();
    }

    @Override
    public List<class_1799> getPatternItems() {
        return Arrays.asList(this.patternItem.method_8105());
    }

    public class_2960 method_8114() {
        return this.id;
    }

    @Override
    public MaterialVariant getMaterial() {
        return this.material;
    }

    @Override
    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public int getCost() {
        return this.cost;
    }

    public static class Serializer
    extends LoggingRecipeSerializer<ItemPartRecipe> {
        public ItemPartRecipe fromJson(class_2960 id, JsonObject json) {
            MaterialVariantId materialId = MaterialVariantId.fromJson(json, "material");
            Pattern pattern = new Pattern(class_3518.method_15265((JsonObject)json, (String)"pattern"));
            class_1856 patternItem = json.has("pattern_item") ? class_1856.method_52177((JsonElement)json.get("pattern_item")) : class_1856.method_8106(TinkerTags.Items.DEFAULT_PATTERNS);
            int cost = class_3518.method_15260((JsonObject)json, (String)"cost");
            ItemOutput result = ItemOutput.fromJson(JsonHelper.getElement(json, "result"));
            return new ItemPartRecipe(id, materialId, pattern, patternItem, cost, result);
        }

        @Override
        @Nullable
        protected ItemPartRecipe fromNetworkSafe(class_2960 id, class_2540 buffer) {
            MaterialVariantId materialId = MaterialVariantId.parse(buffer.method_10800(Short.MAX_VALUE));
            Pattern pattern = new Pattern(buffer.method_10800(Short.MAX_VALUE));
            class_1856 patternItem = class_1856.method_8086((class_2540)buffer);
            int cost = buffer.method_10816();
            ItemOutput result = ItemOutput.read(buffer);
            return new ItemPartRecipe(id, materialId, pattern, patternItem, cost, result);
        }

        @Override
        protected void toNetworkSafe(class_2540 buffer, ItemPartRecipe recipe) {
            buffer.method_10814(recipe.material.getVariant().toString());
            buffer.method_10814(recipe.pattern.toString());
            recipe.patternItem.method_8088(buffer);
            buffer.method_10804(recipe.cost);
            recipe.result.write(buffer);
        }
    }
}

